/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedHalfStairsModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final boolean right;

    public FramedHalfStairsModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        this.right = (Boolean)state.m_61143_((Property)PropertyHolder.RIGHT);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction vertCut;
        Direction face = quad.m_111306_();
        Direction direction = vertCut = this.right ? this.dir.m_122428_() : this.dir.m_122427_();
        if (face == this.dir) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(vertCut, 0.5f)).export(quadMap.get(face));
        } else if (face == this.dir.m_122424_()) {
            QuadModifier mod = QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(vertCut, 0.5f));
            mod.derive().apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            mod.apply(Modifiers.cutSideUpDown(this.top, 0.5f)).export(quadMap.get(face));
        } else if (!Utils.isY(face) && face.m_122434_() != this.dir.m_122434_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir.m_122424_(), 0.5f)).applyIf(Modifiers.setPosition(0.5f), face == vertCut).export(quadMap.get(face == vertCut ? null : face));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).applyIf(Modifiers.setPosition(0.5f), face == vertCut).export(quadMap.get(face == vertCut ? null : face));
        } else if (Utils.isY(face)) {
            boolean base = face == Direction.UP && this.top || face == Direction.DOWN && !this.top;
            QuadModifier mod = QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(vertCut, 0.5f));
            if (!base) {
                mod.derive().apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
            mod.applyIf(Modifiers.cutTopBottom(this.dir.m_122424_(), 0.5f), !base).export(quadMap.get(face));
        }
    }
}

